package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3EncryptionConfiguration(
    objectEncryptionType: zio.aws.qldb.model.S3ObjectEncryptionType,
    kmsKeyArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.S3EncryptionConfiguration = {
    import S3EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.S3EncryptionConfiguration
      .builder()
      .objectEncryptionType(objectEncryptionType.unwrap)
      .optionallyWith(
        kmsKeyArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.S3EncryptionConfiguration.ReadOnly =
    zio.aws.qldb.model.S3EncryptionConfiguration.wrap(buildAwsValue())
}
object S3EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.S3EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.S3EncryptionConfiguration =
      zio.aws.qldb.model.S3EncryptionConfiguration(
        objectEncryptionType,
        kmsKeyArn.map(value => value)
      )
    def objectEncryptionType: zio.aws.qldb.model.S3ObjectEncryptionType
    def kmsKeyArn: Optional[Arn]
    def getObjectEncryptionType
        : ZIO[Any, Nothing, zio.aws.qldb.model.S3ObjectEncryptionType] =
      ZIO.succeed(objectEncryptionType)
    def getKmsKeyArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.S3EncryptionConfiguration
  ) extends zio.aws.qldb.model.S3EncryptionConfiguration.ReadOnly {
    override val objectEncryptionType
        : zio.aws.qldb.model.S3ObjectEncryptionType =
      zio.aws.qldb.model.S3ObjectEncryptionType
        .wrap(impl.objectEncryptionType())
    override val kmsKeyArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.S3EncryptionConfiguration
  ): zio.aws.qldb.model.S3EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
