package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.IonText
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ValueHolder(ionText: Optional[IonText] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ValueHolder = {
    import ValueHolder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ValueHolder
      .builder()
      .optionallyWith(
        ionText.map(value => IonText.unwrap(value): java.lang.String)
      )(_.ionText)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ValueHolder.ReadOnly =
    zio.aws.qldb.model.ValueHolder.wrap(buildAwsValue())
}
object ValueHolder {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.qldb.model.ValueHolder] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ValueHolder =
      zio.aws.qldb.model.ValueHolder(ionText.map(value => value))
    def ionText: Optional[IonText]
    def getIonText: ZIO[Any, AwsError, IonText] =
      AwsError.unwrapOptionField("ionText", ionText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ValueHolder
  ) extends zio.aws.qldb.model.ValueHolder.ReadOnly {
    override val ionText: Optional[IonText] = zio.aws.core.internal
      .optionalFromNullable(impl.ionText())
      .map(value => zio.aws.qldb.model.primitives.IonText(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ValueHolder
  ): zio.aws.qldb.model.ValueHolder.ReadOnly = new Wrapper(impl)
}
