package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{Arn, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLedgerPermissionsModeResponse(
    name: Optional[LedgerName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    permissionsMode: Optional[zio.aws.qldb.model.PermissionsMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeResponse = {
    import UpdateLedgerPermissionsModeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeResponse
      .builder()
      .optionallyWith(
        name.map(value => LedgerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(permissionsMode.map(value => value.unwrap))(
        _.permissionsMode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly =
    zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.wrap(buildAwsValue())
}
object UpdateLedgerPermissionsModeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse =
      zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse(
        name.map(value => value),
        arn.map(value => value),
        permissionsMode.map(value => value)
      )
    def name: Optional[LedgerName]
    def arn: Optional[Arn]
    def permissionsMode: Optional[zio.aws.qldb.model.PermissionsMode]
    def getName: ZIO[Any, AwsError, LedgerName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getPermissionsMode
        : ZIO[Any, AwsError, zio.aws.qldb.model.PermissionsMode] =
      AwsError.unwrapOptionField("permissionsMode", permissionsMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeResponse
  ) extends zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly {
    override val name: Optional[LedgerName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.qldb.model.primitives.LedgerName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
    override val permissionsMode: Optional[zio.aws.qldb.model.PermissionsMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsMode())
        .map(value => zio.aws.qldb.model.PermissionsMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeResponse
  ): zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly =
    new Wrapper(impl)
}
