package zio.aws.qldb.model
import scala.jdk.CollectionConverters.*
sealed trait OutputFormat {
  def unwrap: software.amazon.awssdk.services.qldb.model.OutputFormat
}
object OutputFormat {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.OutputFormat
  ): zio.aws.qldb.model.OutputFormat = value match {
    case software.amazon.awssdk.services.qldb.model.OutputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.OutputFormat.ION_BINARY =>
      val r = ION_BINARY
      r
    case software.amazon.awssdk.services.qldb.model.OutputFormat.ION_TEXT =>
      val r = ION_TEXT
      r
    case software.amazon.awssdk.services.qldb.model.OutputFormat.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.OutputFormat =
      software.amazon.awssdk.services.qldb.model.OutputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object ION_BINARY extends zio.aws.qldb.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.OutputFormat =
      software.amazon.awssdk.services.qldb.model.OutputFormat.ION_BINARY
  }
  case object ION_TEXT extends zio.aws.qldb.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.OutputFormat =
      software.amazon.awssdk.services.qldb.model.OutputFormat.ION_TEXT
  }
  case object JSON extends zio.aws.qldb.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.OutputFormat =
      software.amazon.awssdk.services.qldb.model.OutputFormat.JSON
  }
}
