package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJournalKinesisStreamsForLedgerResponse(
    streams: Optional[
      Iterable[zio.aws.qldb.model.JournalKinesisStreamDescription]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse = {
    import ListJournalKinesisStreamsForLedgerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
      .builder()
      .optionallyWith(
        streams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streams)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly =
    zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse
      .wrap(buildAwsValue())
}
object ListJournalKinesisStreamsForLedgerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse =
      zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse(
        streams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def streams: Optional[
      List[zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getStreams: ZIO[Any, AwsError, List[
      zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("streams", streams)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
  ) extends zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly {
    override val streams: Optional[
      List[zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streams())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.qldb.model.JournalKinesisStreamDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
  ): zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly =
    new Wrapper(impl)
}
