package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.UniqueId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportJournalToS3Response(exportId: UniqueId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response = {
    import ExportJournalToS3Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response
      .builder()
      .exportId(UniqueId.unwrap(exportId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly =
    zio.aws.qldb.model.ExportJournalToS3Response.wrap(buildAwsValue())
}
object ExportJournalToS3Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ExportJournalToS3Response =
      zio.aws.qldb.model.ExportJournalToS3Response(exportId)
    def exportId: UniqueId
    def getExportId: ZIO[Any, Nothing, UniqueId] = ZIO.succeed(exportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response
  ) extends zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly {
    override val exportId: UniqueId =
      zio.aws.qldb.model.primitives.UniqueId(impl.exportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response
  ): zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly = new Wrapper(impl)
}
