package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.LedgerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDigestRequest(name: LedgerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.GetDigestRequest = {
    import GetDigestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.GetDigestRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.GetDigestRequest.ReadOnly =
    zio.aws.qldb.model.GetDigestRequest.wrap(buildAwsValue())
}
object GetDigestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.GetDigestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.GetDigestRequest =
      zio.aws.qldb.model.GetDigestRequest(name)
    def name: LedgerName
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.GetDigestRequest
  ) extends zio.aws.qldb.model.GetDigestRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.GetDigestRequest
  ): zio.aws.qldb.model.GetDigestRequest.ReadOnly = new Wrapper(impl)
}
