package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.LedgerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeLedgerRequest(name: LedgerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest = {
    import DescribeLedgerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.DescribeLedgerRequest.ReadOnly =
    zio.aws.qldb.model.DescribeLedgerRequest.wrap(buildAwsValue())
}
object DescribeLedgerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.DescribeLedgerRequest =
      zio.aws.qldb.model.DescribeLedgerRequest(name)
    def name: LedgerName
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest
  ) extends zio.aws.qldb.model.DescribeLedgerRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest
  ): zio.aws.qldb.model.DescribeLedgerRequest.ReadOnly = new Wrapper(impl)
}
