package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{UniqueId, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRevisionRequest(
    name: LedgerName,
    blockAddress: zio.aws.qldb.model.ValueHolder,
    documentId: UniqueId,
    digestTipAddress: Option[zio.aws.qldb.model.ValueHolder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.GetRevisionRequest = {
    import GetRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.GetRevisionRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .blockAddress(blockAddress.buildAwsValue())
      .documentId(UniqueId.unwrap(documentId): java.lang.String)
      .optionallyWith(digestTipAddress.map(value => value.buildAwsValue()))(
        _.digestTipAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.GetRevisionRequest.ReadOnly =
    zio.aws.qldb.model.GetRevisionRequest.wrap(buildAwsValue())
}
object GetRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.GetRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.GetRevisionRequest =
      zio.aws.qldb.model.GetRevisionRequest(
        name,
        blockAddress.asEditable,
        documentId,
        digestTipAddress.map(value => value.asEditable)
      )
    def name: LedgerName
    def blockAddress: zio.aws.qldb.model.ValueHolder.ReadOnly
    def documentId: UniqueId
    def digestTipAddress: Option[zio.aws.qldb.model.ValueHolder.ReadOnly]
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getBlockAddress
        : ZIO[Any, Nothing, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      ZIO.succeed(blockAddress)
    def getDocumentId: ZIO[Any, Nothing, UniqueId] = ZIO.succeed(documentId)
    def getDigestTipAddress
        : ZIO[Any, AwsError, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      AwsError.unwrapOptionField("digestTipAddress", digestTipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.GetRevisionRequest
  ) extends zio.aws.qldb.model.GetRevisionRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val blockAddress: zio.aws.qldb.model.ValueHolder.ReadOnly =
      zio.aws.qldb.model.ValueHolder.wrap(impl.blockAddress())
    override val documentId: UniqueId =
      zio.aws.qldb.model.primitives.UniqueId(impl.documentId())
    override val digestTipAddress
        : Option[zio.aws.qldb.model.ValueHolder.ReadOnly] = scala
      .Option(impl.digestTipAddress())
      .map(value => zio.aws.qldb.model.ValueHolder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.GetRevisionRequest
  ): zio.aws.qldb.model.GetRevisionRequest.ReadOnly = new Wrapper(impl)
}
