package zio.aws.qldb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.qldb.model.primitives.{NextToken, MaxResults, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJournalKinesisStreamsForLedgerRequest(
    ledgerName: LedgerName,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest = {
    import ListJournalKinesisStreamsForLedgerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
      .builder()
      .ledgerName(LedgerName.unwrap(ledgerName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest.ReadOnly =
    zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
      .wrap(buildAwsValue())
}
object ListJournalKinesisStreamsForLedgerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest =
      zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest(
        ledgerName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def ledgerName: LedgerName
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getLedgerName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(ledgerName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ) extends zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest.ReadOnly {
    override val ledgerName: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.ledgerName())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.qldb.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ): zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest.ReadOnly =
    new Wrapper(impl)
}
