package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{Timestamp, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class LedgerSummary(
    name: Option[LedgerName] = None,
    state: Option[zio.aws.qldb.model.LedgerState] = None,
    creationDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.LedgerSummary = {
    import LedgerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.LedgerSummary
      .builder()
      .optionallyWith(
        name.map(value => LedgerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.LedgerSummary.ReadOnly =
    zio.aws.qldb.model.LedgerSummary.wrap(buildAwsValue())
}
object LedgerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.LedgerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.LedgerSummary =
      zio.aws.qldb.model.LedgerSummary(
        name.map(value => value),
        state.map(value => value),
        creationDateTime.map(value => value)
      )
    def name: Option[LedgerName]
    def state: Option[zio.aws.qldb.model.LedgerState]
    def creationDateTime: Option[Timestamp]
    def getName: ZIO[Any, AwsError, LedgerName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.qldb.model.LedgerState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.LedgerSummary
  ) extends zio.aws.qldb.model.LedgerSummary.ReadOnly {
    override val name: Option[LedgerName] = scala
      .Option(impl.name())
      .map(value => zio.aws.qldb.model.primitives.LedgerName(value))
    override val state: Option[zio.aws.qldb.model.LedgerState] = scala
      .Option(impl.state())
      .map(value => zio.aws.qldb.model.LedgerState.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.LedgerSummary
  ): zio.aws.qldb.model.LedgerSummary.ReadOnly = new Wrapper(impl)
}
