package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.UniqueId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StreamJournalToKinesisResponse(
    streamId: Option[UniqueId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse = {
    import StreamJournalToKinesisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse
      .builder()
      .optionallyWith(
        streamId.map(value => UniqueId.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly =
    zio.aws.qldb.model.StreamJournalToKinesisResponse.wrap(buildAwsValue())
}
object StreamJournalToKinesisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.StreamJournalToKinesisResponse =
      zio.aws.qldb.model
        .StreamJournalToKinesisResponse(streamId.map(value => value))
    def streamId: Option[UniqueId]
    def getStreamId: ZIO[Any, AwsError, UniqueId] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse
  ) extends zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly {
    override val streamId: Option[UniqueId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.qldb.model.primitives.UniqueId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse
  ): zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly = new Wrapper(
    impl
  )
}
