package zio.aws.qldb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.qldb.model.primitives.{NextToken, MaxResults, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJournalS3ExportsForLedgerRequest(
    name: LedgerName,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest = {
    import ListJournalS3ExportsForLedgerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest.ReadOnly =
    zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
      .wrap(buildAwsValue())
}
object ListJournalS3ExportsForLedgerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest =
      zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest(
        name,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: LedgerName
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest
  ) extends zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.qldb.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest
  ): zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest.ReadOnly =
    new Wrapper(impl)
}
