package zio.aws.qldb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.qldb.model.primitives.{NextToken, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJournalS3ExportsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest = {
    import ListJournalS3ExportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ListJournalS3ExportsRequest.ReadOnly =
    zio.aws.qldb.model.ListJournalS3ExportsRequest.wrap(buildAwsValue())
}
object ListJournalS3ExportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ListJournalS3ExportsRequest =
      zio.aws.qldb.model.ListJournalS3ExportsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest
  ) extends zio.aws.qldb.model.ListJournalS3ExportsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.qldb.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest
  ): zio.aws.qldb.model.ListJournalS3ExportsRequest.ReadOnly = new Wrapper(impl)
}
