package zio.aws.qldb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.qldb.model.primitives.{NextToken, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLedgersRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListLedgersRequest = {
    import ListLedgersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListLedgersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ListLedgersRequest.ReadOnly =
    zio.aws.qldb.model.ListLedgersRequest.wrap(buildAwsValue())
}
object ListLedgersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListLedgersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ListLedgersRequest =
      zio.aws.qldb.model.ListLedgersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListLedgersRequest
  ) extends zio.aws.qldb.model.ListLedgersRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.qldb.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListLedgersRequest
  ): zio.aws.qldb.model.ListLedgersRequest.ReadOnly = new Wrapper(impl)
}
