package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{UniqueId, LedgerName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelJournalKinesisStreamRequest(
    ledgerName: LedgerName,
    streamId: UniqueId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest = {
    import CancelJournalKinesisStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest
      .builder()
      .ledgerName(LedgerName.unwrap(ledgerName): java.lang.String)
      .streamId(UniqueId.unwrap(streamId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.CancelJournalKinesisStreamRequest.ReadOnly =
    zio.aws.qldb.model.CancelJournalKinesisStreamRequest.wrap(buildAwsValue())
}
object CancelJournalKinesisStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.CancelJournalKinesisStreamRequest =
      zio.aws.qldb.model.CancelJournalKinesisStreamRequest(ledgerName, streamId)
    def ledgerName: LedgerName
    def streamId: UniqueId
    def getLedgerName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(ledgerName)
    def getStreamId: ZIO[Any, Nothing, UniqueId] = ZIO.succeed(streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest
  ) extends zio.aws.qldb.model.CancelJournalKinesisStreamRequest.ReadOnly {
    override val ledgerName: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.ledgerName())
    override val streamId: UniqueId =
      zio.aws.qldb.model.primitives.UniqueId(impl.streamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest
  ): zio.aws.qldb.model.CancelJournalKinesisStreamRequest.ReadOnly =
    new Wrapper(impl)
}
