package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJournalS3ExportsForLedgerResponse(
    journalS3Exports: Optional[
      Iterable[zio.aws.qldb.model.JournalS3ExportDescription]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse = {
    import ListJournalS3ExportsForLedgerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse
      .builder()
      .optionallyWith(
        journalS3Exports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.journalS3Exports)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly =
    zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse
      .wrap(buildAwsValue())
}
object ListJournalS3ExportsForLedgerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse =
      zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse(
        journalS3Exports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def journalS3Exports
        : Optional[List[zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getJournalS3Exports: ZIO[Any, AwsError, List[
      zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("journalS3Exports", journalS3Exports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse
  ) extends zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly {
    override val journalS3Exports: Optional[
      List[zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.journalS3Exports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.qldb.model.JournalS3ExportDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse
  ): zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly =
    new Wrapper(impl)
}
