package zio.aws.qldb.model
import scala.jdk.CollectionConverters._
sealed trait S3ObjectEncryptionType {
  def unwrap: software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType
}
object S3ObjectEncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType
  ): zio.aws.qldb.model.S3ObjectEncryptionType = value match {
    case software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.SSE_KMS =>
      val r = SSE_KMS
      r
    case software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.SSE_S3 =>
      val r = SSE_S3
      r
    case software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.NO_ENCRYPTION =>
      val r = NO_ENCRYPTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.qldb.model.S3ObjectEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType =
      software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSE_KMS extends zio.aws.qldb.model.S3ObjectEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType =
      software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.SSE_KMS
  }
  case object SSE_S3 extends zio.aws.qldb.model.S3ObjectEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType =
      software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.SSE_S3
  }
  case object NO_ENCRYPTION extends zio.aws.qldb.model.S3ObjectEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType =
      software.amazon.awssdk.services.qldb.model.S3ObjectEncryptionType.NO_ENCRYPTION
  }
}
