package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.UniqueId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelJournalKinesisStreamResponse(
    streamId: Optional[UniqueId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse = {
    import CancelJournalKinesisStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse
      .builder()
      .optionallyWith(
        streamId.map(value => UniqueId.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly =
    zio.aws.qldb.model.CancelJournalKinesisStreamResponse.wrap(buildAwsValue())
}
object CancelJournalKinesisStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.CancelJournalKinesisStreamResponse =
      zio.aws.qldb.model
        .CancelJournalKinesisStreamResponse(streamId.map(value => value))
    def streamId: Optional[UniqueId]
    def getStreamId: ZIO[Any, AwsError, UniqueId] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse
  ) extends zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly {
    override val streamId: Optional[UniqueId] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => zio.aws.qldb.model.primitives.UniqueId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse
  ): zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly =
    new Wrapper(impl)
}
