package zio.aws.qldb.model
import scala.jdk.CollectionConverters._
sealed trait LedgerState {
  def unwrap: software.amazon.awssdk.services.qldb.model.LedgerState
}
object LedgerState {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.LedgerState
  ): zio.aws.qldb.model.LedgerState = value match {
    case software.amazon.awssdk.services.qldb.model.LedgerState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.LedgerState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.qldb.model.LedgerState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.qldb.model.LedgerState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.qldb.model.LedgerState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.LedgerState {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.LedgerState =
      software.amazon.awssdk.services.qldb.model.LedgerState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.qldb.model.LedgerState {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.LedgerState =
      software.amazon.awssdk.services.qldb.model.LedgerState.CREATING
  }
  case object ACTIVE extends zio.aws.qldb.model.LedgerState {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.LedgerState =
      software.amazon.awssdk.services.qldb.model.LedgerState.ACTIVE
  }
  case object DELETING extends zio.aws.qldb.model.LedgerState {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.LedgerState =
      software.amazon.awssdk.services.qldb.model.LedgerState.DELETING
  }
  case object DELETED extends zio.aws.qldb.model.LedgerState {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.LedgerState =
      software.amazon.awssdk.services.qldb.model.LedgerState.DELETED
  }
}
