package zio.aws.qldb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.qldb.model.primitives.{
  DeletionProtection,
  Timestamp,
  Arn,
  LedgerName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateLedgerResponse(
    name: Optional[LedgerName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    state: Optional[zio.aws.qldb.model.LedgerState] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    permissionsMode: Optional[zio.aws.qldb.model.PermissionsMode] =
      Optional.Absent,
    deletionProtection: Optional[DeletionProtection] = Optional.Absent,
    kmsKeyArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.CreateLedgerResponse = {
    import CreateLedgerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
      .builder()
      .optionallyWith(
        name.map(value => LedgerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(permissionsMode.map(value => value.unwrap))(
        _.permissionsMode
      )
      .optionallyWith(
        deletionProtection.map(value =>
          DeletionProtection.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        kmsKeyArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.CreateLedgerResponse.ReadOnly =
    zio.aws.qldb.model.CreateLedgerResponse.wrap(buildAwsValue())
}
object CreateLedgerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.CreateLedgerResponse =
      zio.aws.qldb.model.CreateLedgerResponse(
        name.map(value => value),
        arn.map(value => value),
        state.map(value => value),
        creationDateTime.map(value => value),
        permissionsMode.map(value => value),
        deletionProtection.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def name: Optional[LedgerName]
    def arn: Optional[Arn]
    def state: Optional[zio.aws.qldb.model.LedgerState]
    def creationDateTime: Optional[Timestamp]
    def permissionsMode: Optional[zio.aws.qldb.model.PermissionsMode]
    def deletionProtection: Optional[DeletionProtection]
    def kmsKeyArn: Optional[Arn]
    def getName: ZIO[Any, AwsError, LedgerName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getState: ZIO[Any, AwsError, zio.aws.qldb.model.LedgerState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getPermissionsMode
        : ZIO[Any, AwsError, zio.aws.qldb.model.PermissionsMode] =
      AwsError.unwrapOptionField("permissionsMode", permissionsMode)
    def getDeletionProtection: ZIO[Any, AwsError, DeletionProtection] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getKmsKeyArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
  ) extends zio.aws.qldb.model.CreateLedgerResponse.ReadOnly {
    override val name: Optional[LedgerName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.qldb.model.primitives.LedgerName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
    override val state: Optional[zio.aws.qldb.model.LedgerState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.qldb.model.LedgerState.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
    override val permissionsMode: Optional[zio.aws.qldb.model.PermissionsMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsMode())
        .map(value => zio.aws.qldb.model.PermissionsMode.wrap(value))
    override val deletionProtection: Optional[DeletionProtection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => zio.aws.qldb.model.primitives.DeletionProtection(value))
    override val kmsKeyArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
  ): zio.aws.qldb.model.CreateLedgerResponse.ReadOnly = new Wrapper(impl)
}
