package zio.aws.qldb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.qldb.model.primitives.{Arn, Timestamp, UniqueId, LedgerName}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class JournalS3ExportDescription(
    ledgerName: LedgerName,
    exportId: UniqueId,
    exportCreationTime: Timestamp,
    status: zio.aws.qldb.model.ExportStatus,
    inclusiveStartTime: Timestamp,
    exclusiveEndTime: Timestamp,
    s3ExportConfiguration: zio.aws.qldb.model.S3ExportConfiguration,
    roleArn: Arn,
    outputFormat: Optional[zio.aws.qldb.model.OutputFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription = {
    import JournalS3ExportDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription
      .builder()
      .ledgerName(LedgerName.unwrap(ledgerName): java.lang.String)
      .exportId(UniqueId.unwrap(exportId): java.lang.String)
      .exportCreationTime(Timestamp.unwrap(exportCreationTime): Instant)
      .status(status.unwrap)
      .inclusiveStartTime(Timestamp.unwrap(inclusiveStartTime): Instant)
      .exclusiveEndTime(Timestamp.unwrap(exclusiveEndTime): Instant)
      .s3ExportConfiguration(s3ExportConfiguration.buildAwsValue())
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly =
    zio.aws.qldb.model.JournalS3ExportDescription.wrap(buildAwsValue())
}
object JournalS3ExportDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.JournalS3ExportDescription =
      zio.aws.qldb.model.JournalS3ExportDescription(
        ledgerName,
        exportId,
        exportCreationTime,
        status,
        inclusiveStartTime,
        exclusiveEndTime,
        s3ExportConfiguration.asEditable,
        roleArn,
        outputFormat.map(value => value)
      )
    def ledgerName: LedgerName
    def exportId: UniqueId
    def exportCreationTime: Timestamp
    def status: zio.aws.qldb.model.ExportStatus
    def inclusiveStartTime: Timestamp
    def exclusiveEndTime: Timestamp
    def s3ExportConfiguration: zio.aws.qldb.model.S3ExportConfiguration.ReadOnly
    def roleArn: Arn
    def outputFormat: Optional[zio.aws.qldb.model.OutputFormat]
    def getLedgerName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(ledgerName)
    def getExportId: ZIO[Any, Nothing, UniqueId] = ZIO.succeed(exportId)
    def getExportCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(exportCreationTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.qldb.model.ExportStatus] =
      ZIO.succeed(status)
    def getInclusiveStartTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(inclusiveStartTime)
    def getExclusiveEndTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(exclusiveEndTime)
    def getS3ExportConfiguration
        : ZIO[Any, Nothing, zio.aws.qldb.model.S3ExportConfiguration.ReadOnly] =
      ZIO.succeed(s3ExportConfiguration)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getOutputFormat: ZIO[Any, AwsError, zio.aws.qldb.model.OutputFormat] =
      AwsError.unwrapOptionField("outputFormat", outputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription
  ) extends zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly {
    override val ledgerName: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.ledgerName())
    override val exportId: UniqueId =
      zio.aws.qldb.model.primitives.UniqueId(impl.exportId())
    override val exportCreationTime: Timestamp =
      zio.aws.qldb.model.primitives.Timestamp(impl.exportCreationTime())
    override val status: zio.aws.qldb.model.ExportStatus =
      zio.aws.qldb.model.ExportStatus.wrap(impl.status())
    override val inclusiveStartTime: Timestamp =
      zio.aws.qldb.model.primitives.Timestamp(impl.inclusiveStartTime())
    override val exclusiveEndTime: Timestamp =
      zio.aws.qldb.model.primitives.Timestamp(impl.exclusiveEndTime())
    override val s3ExportConfiguration
        : zio.aws.qldb.model.S3ExportConfiguration.ReadOnly =
      zio.aws.qldb.model.S3ExportConfiguration
        .wrap(impl.s3ExportConfiguration())
    override val roleArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.roleArn())
    override val outputFormat: Optional[zio.aws.qldb.model.OutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputFormat())
        .map(value => zio.aws.qldb.model.OutputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription
  ): zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly = new Wrapper(impl)
}
