package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.LedgerName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBlockRequest(
    name: LedgerName,
    blockAddress: zio.aws.qldb.model.ValueHolder,
    digestTipAddress: Option[zio.aws.qldb.model.ValueHolder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.GetBlockRequest = {
    import GetBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.GetBlockRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .blockAddress(blockAddress.buildAwsValue())
      .optionallyWith(digestTipAddress.map(value => value.buildAwsValue()))(
        _.digestTipAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.GetBlockRequest.ReadOnly =
    zio.aws.qldb.model.GetBlockRequest.wrap(buildAwsValue())
}
object GetBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.GetBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.GetBlockRequest =
      zio.aws.qldb.model.GetBlockRequest(
        name,
        blockAddress.asEditable,
        digestTipAddress.map(value => value.asEditable)
      )
    def name: LedgerName
    def blockAddress: zio.aws.qldb.model.ValueHolder.ReadOnly
    def digestTipAddress: Option[zio.aws.qldb.model.ValueHolder.ReadOnly]
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getBlockAddress
        : ZIO[Any, Nothing, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      ZIO.succeed(blockAddress)
    def getDigestTipAddress
        : ZIO[Any, AwsError, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      AwsError.unwrapOptionField("digestTipAddress", digestTipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.GetBlockRequest
  ) extends zio.aws.qldb.model.GetBlockRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val blockAddress: zio.aws.qldb.model.ValueHolder.ReadOnly =
      zio.aws.qldb.model.ValueHolder.wrap(impl.blockAddress())
    override val digestTipAddress
        : Option[zio.aws.qldb.model.ValueHolder.ReadOnly] = scala
      .Option(impl.digestTipAddress())
      .map(value => zio.aws.qldb.model.ValueHolder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.GetBlockRequest
  ): zio.aws.qldb.model.GetBlockRequest.ReadOnly = new Wrapper(impl)
}
