package zio.aws.qldb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRevisionResponse(
    proof: Option[zio.aws.qldb.model.ValueHolder] = None,
    revision: zio.aws.qldb.model.ValueHolder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.GetRevisionResponse = {
    import GetRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.GetRevisionResponse
      .builder()
      .optionallyWith(proof.map(value => value.buildAwsValue()))(_.proof)
      .revision(revision.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.GetRevisionResponse.ReadOnly =
    zio.aws.qldb.model.GetRevisionResponse.wrap(buildAwsValue())
}
object GetRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.GetRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.GetRevisionResponse =
      zio.aws.qldb.model.GetRevisionResponse(
        proof.map(value => value.asEditable),
        revision.asEditable
      )
    def proof: Option[zio.aws.qldb.model.ValueHolder.ReadOnly]
    def revision: zio.aws.qldb.model.ValueHolder.ReadOnly
    def getProof: ZIO[Any, AwsError, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      AwsError.unwrapOptionField("proof", proof)
    def getRevision
        : ZIO[Any, Nothing, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.GetRevisionResponse
  ) extends zio.aws.qldb.model.GetRevisionResponse.ReadOnly {
    override val proof: Option[zio.aws.qldb.model.ValueHolder.ReadOnly] = scala
      .Option(impl.proof())
      .map(value => zio.aws.qldb.model.ValueHolder.wrap(value))
    override val revision: zio.aws.qldb.model.ValueHolder.ReadOnly =
      zio.aws.qldb.model.ValueHolder.wrap(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.GetRevisionResponse
  ): zio.aws.qldb.model.GetRevisionResponse.ReadOnly = new Wrapper(impl)
}
