package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{KmsKey, DeletionProtection, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLedgerRequest(
    name: LedgerName,
    deletionProtection: Option[DeletionProtection] = None,
    kmsKey: Option[KmsKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest = {
    import UpdateLedgerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .optionallyWith(
        deletionProtection.map(value =>
          DeletionProtection.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.UpdateLedgerRequest.ReadOnly =
    zio.aws.qldb.model.UpdateLedgerRequest.wrap(buildAwsValue())
}
object UpdateLedgerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.UpdateLedgerRequest =
      zio.aws.qldb.model.UpdateLedgerRequest(
        name,
        deletionProtection.map(value => value),
        kmsKey.map(value => value)
      )
    def name: LedgerName
    def deletionProtection: Option[DeletionProtection]
    def kmsKey: Option[KmsKey]
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getDeletionProtection: ZIO[Any, AwsError, DeletionProtection] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest
  ) extends zio.aws.qldb.model.UpdateLedgerRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val deletionProtection: Option[DeletionProtection] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.qldb.model.primitives.DeletionProtection(value))
    override val kmsKey: Option[KmsKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.qldb.model.primitives.KmsKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest
  ): zio.aws.qldb.model.UpdateLedgerRequest.ReadOnly = new Wrapper(impl)
}
