package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{
  StreamName,
  Timestamp,
  TagValue,
  Arn,
  LedgerName,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StreamJournalToKinesisRequest(
    ledgerName: LedgerName,
    roleArn: Arn,
    tags: Option[Map[TagKey, TagValue]] = None,
    inclusiveStartTime: Timestamp,
    exclusiveEndTime: Option[Timestamp] = None,
    kinesisConfiguration: zio.aws.qldb.model.KinesisConfiguration,
    streamName: StreamName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest = {
    import StreamJournalToKinesisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest
      .builder()
      .ledgerName(LedgerName.unwrap(ledgerName): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .inclusiveStartTime(Timestamp.unwrap(inclusiveStartTime): Instant)
      .optionallyWith(
        exclusiveEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.exclusiveEndTime)
      .kinesisConfiguration(kinesisConfiguration.buildAwsValue())
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.StreamJournalToKinesisRequest.ReadOnly =
    zio.aws.qldb.model.StreamJournalToKinesisRequest.wrap(buildAwsValue())
}
object StreamJournalToKinesisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.StreamJournalToKinesisRequest =
      zio.aws.qldb.model.StreamJournalToKinesisRequest(
        ledgerName,
        roleArn,
        tags.map(value => value),
        inclusiveStartTime,
        exclusiveEndTime.map(value => value),
        kinesisConfiguration.asEditable,
        streamName
      )
    def ledgerName: LedgerName
    def roleArn: Arn
    def tags: Option[Map[TagKey, TagValue]]
    def inclusiveStartTime: Timestamp
    def exclusiveEndTime: Option[Timestamp]
    def kinesisConfiguration: zio.aws.qldb.model.KinesisConfiguration.ReadOnly
    def streamName: StreamName
    def getLedgerName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(ledgerName)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getInclusiveStartTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(inclusiveStartTime)
    def getExclusiveEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("exclusiveEndTime", exclusiveEndTime)
    def getKinesisConfiguration
        : ZIO[Any, Nothing, zio.aws.qldb.model.KinesisConfiguration.ReadOnly] =
      ZIO.succeed(kinesisConfiguration)
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest
  ) extends zio.aws.qldb.model.StreamJournalToKinesisRequest.ReadOnly {
    override val ledgerName: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.ledgerName())
    override val roleArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.roleArn())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.qldb.model.primitives
              .TagKey(key) -> zio.aws.qldb.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val inclusiveStartTime: Timestamp =
      zio.aws.qldb.model.primitives.Timestamp(impl.inclusiveStartTime())
    override val exclusiveEndTime: Option[Timestamp] = scala
      .Option(impl.exclusiveEndTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
    override val kinesisConfiguration
        : zio.aws.qldb.model.KinesisConfiguration.ReadOnly =
      zio.aws.qldb.model.KinesisConfiguration.wrap(impl.kinesisConfiguration())
    override val streamName: StreamName =
      zio.aws.qldb.model.primitives.StreamName(impl.streamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest
  ): zio.aws.qldb.model.StreamJournalToKinesisRequest.ReadOnly = new Wrapper(
    impl
  )
}
