package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{
  DeletionProtection,
  Timestamp,
  Arn,
  LedgerName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateLedgerResponse(
    name: Option[LedgerName] = None,
    arn: Option[Arn] = None,
    state: Option[zio.aws.qldb.model.LedgerState] = None,
    creationDateTime: Option[Timestamp] = None,
    permissionsMode: Option[zio.aws.qldb.model.PermissionsMode] = None,
    deletionProtection: Option[DeletionProtection] = None,
    kmsKeyArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.CreateLedgerResponse = {
    import CreateLedgerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
      .builder()
      .optionallyWith(
        name.map(value => LedgerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(permissionsMode.map(value => value.unwrap))(
        _.permissionsMode
      )
      .optionallyWith(
        deletionProtection.map(value =>
          DeletionProtection.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        kmsKeyArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.CreateLedgerResponse.ReadOnly =
    zio.aws.qldb.model.CreateLedgerResponse.wrap(buildAwsValue())
}
object CreateLedgerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.CreateLedgerResponse =
      zio.aws.qldb.model.CreateLedgerResponse(
        name.map(value => value),
        arn.map(value => value),
        state.map(value => value),
        creationDateTime.map(value => value),
        permissionsMode.map(value => value),
        deletionProtection.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def name: Option[LedgerName]
    def arn: Option[Arn]
    def state: Option[zio.aws.qldb.model.LedgerState]
    def creationDateTime: Option[Timestamp]
    def permissionsMode: Option[zio.aws.qldb.model.PermissionsMode]
    def deletionProtection: Option[DeletionProtection]
    def kmsKeyArn: Option[Arn]
    def getName: ZIO[Any, AwsError, LedgerName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getState: ZIO[Any, AwsError, zio.aws.qldb.model.LedgerState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getPermissionsMode
        : ZIO[Any, AwsError, zio.aws.qldb.model.PermissionsMode] =
      AwsError.unwrapOptionField("permissionsMode", permissionsMode)
    def getDeletionProtection: ZIO[Any, AwsError, DeletionProtection] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getKmsKeyArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
  ) extends zio.aws.qldb.model.CreateLedgerResponse.ReadOnly {
    override val name: Option[LedgerName] = scala
      .Option(impl.name())
      .map(value => zio.aws.qldb.model.primitives.LedgerName(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
    override val state: Option[zio.aws.qldb.model.LedgerState] = scala
      .Option(impl.state())
      .map(value => zio.aws.qldb.model.LedgerState.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
    override val permissionsMode: Option[zio.aws.qldb.model.PermissionsMode] =
      scala
        .Option(impl.permissionsMode())
        .map(value => zio.aws.qldb.model.PermissionsMode.wrap(value))
    override val deletionProtection: Option[DeletionProtection] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.qldb.model.primitives.DeletionProtection(value))
    override val kmsKeyArn: Option[Arn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.CreateLedgerResponse
  ): zio.aws.qldb.model.CreateLedgerResponse.ReadOnly = new Wrapper(impl)
}
