package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{
  DeletionProtection,
  TagValue,
  KmsKey,
  LedgerName,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLedgerRequest(
    name: LedgerName,
    tags: Option[Map[TagKey, TagValue]] = None,
    permissionsMode: zio.aws.qldb.model.PermissionsMode,
    deletionProtection: Option[DeletionProtection] = None,
    kmsKey: Option[KmsKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.CreateLedgerRequest = {
    import CreateLedgerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.CreateLedgerRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .permissionsMode(permissionsMode.unwrap)
      .optionallyWith(
        deletionProtection.map(value =>
          DeletionProtection.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.CreateLedgerRequest.ReadOnly =
    zio.aws.qldb.model.CreateLedgerRequest.wrap(buildAwsValue())
}
object CreateLedgerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.CreateLedgerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.CreateLedgerRequest =
      zio.aws.qldb.model.CreateLedgerRequest(
        name,
        tags.map(value => value),
        permissionsMode,
        deletionProtection.map(value => value),
        kmsKey.map(value => value)
      )
    def name: LedgerName
    def tags: Option[Map[TagKey, TagValue]]
    def permissionsMode: zio.aws.qldb.model.PermissionsMode
    def deletionProtection: Option[DeletionProtection]
    def kmsKey: Option[KmsKey]
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPermissionsMode
        : ZIO[Any, Nothing, zio.aws.qldb.model.PermissionsMode] =
      ZIO.succeed(permissionsMode)
    def getDeletionProtection: ZIO[Any, AwsError, DeletionProtection] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.CreateLedgerRequest
  ) extends zio.aws.qldb.model.CreateLedgerRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.qldb.model.primitives
              .TagKey(key) -> zio.aws.qldb.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val permissionsMode: zio.aws.qldb.model.PermissionsMode =
      zio.aws.qldb.model.PermissionsMode.wrap(impl.permissionsMode())
    override val deletionProtection: Option[DeletionProtection] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.qldb.model.primitives.DeletionProtection(value))
    override val kmsKey: Option[KmsKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.qldb.model.primitives.KmsKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.CreateLedgerRequest
  ): zio.aws.qldb.model.CreateLedgerRequest.ReadOnly = new Wrapper(impl)
}
