package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{Timestamp, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LedgerEncryptionDescription(
    kmsKeyArn: Arn,
    encryptionStatus: zio.aws.qldb.model.EncryptionStatus,
    inaccessibleKmsKeyDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription = {
    import LedgerEncryptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription
      .builder()
      .kmsKeyArn(Arn.unwrap(kmsKeyArn): java.lang.String)
      .encryptionStatus(encryptionStatus.unwrap)
      .optionallyWith(
        inaccessibleKmsKeyDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.inaccessibleKmsKeyDateTime)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.LedgerEncryptionDescription.ReadOnly =
    zio.aws.qldb.model.LedgerEncryptionDescription.wrap(buildAwsValue())
}
object LedgerEncryptionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.LedgerEncryptionDescription =
      zio.aws.qldb.model.LedgerEncryptionDescription(
        kmsKeyArn,
        encryptionStatus,
        inaccessibleKmsKeyDateTime.map(value => value)
      )
    def kmsKeyArn: Arn
    def encryptionStatus: zio.aws.qldb.model.EncryptionStatus
    def inaccessibleKmsKeyDateTime: Option[Timestamp]
    def getKmsKeyArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(kmsKeyArn)
    def getEncryptionStatus
        : ZIO[Any, Nothing, zio.aws.qldb.model.EncryptionStatus] =
      ZIO.succeed(encryptionStatus)
    def getInaccessibleKmsKeyDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "inaccessibleKmsKeyDateTime",
        inaccessibleKmsKeyDateTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription
  ) extends zio.aws.qldb.model.LedgerEncryptionDescription.ReadOnly {
    override val kmsKeyArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.kmsKeyArn())
    override val encryptionStatus: zio.aws.qldb.model.EncryptionStatus =
      zio.aws.qldb.model.EncryptionStatus.wrap(impl.encryptionStatus())
    override val inaccessibleKmsKeyDateTime: Option[Timestamp] = scala
      .Option(impl.inaccessibleKmsKeyDateTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription
  ): zio.aws.qldb.model.LedgerEncryptionDescription.ReadOnly = new Wrapper(impl)
}
