package zio.aws.qldb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeJournalKinesisStreamResponse(
    stream: Option[zio.aws.qldb.model.JournalKinesisStreamDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse = {
    import DescribeJournalKinesisStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse
      .builder()
      .optionallyWith(stream.map(value => value.buildAwsValue()))(_.stream)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly =
    zio.aws.qldb.model.DescribeJournalKinesisStreamResponse
      .wrap(buildAwsValue())
}
object DescribeJournalKinesisStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.DescribeJournalKinesisStreamResponse =
      zio.aws.qldb.model.DescribeJournalKinesisStreamResponse(
        stream.map(value => value.asEditable)
      )
    def stream
        : Option[zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly]
    def getStream: ZIO[
      Any,
      AwsError,
      zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
    ] = AwsError.unwrapOptionField("stream", stream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse
  ) extends zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly {
    override val stream
        : Option[zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly] =
      scala
        .Option(impl.stream())
        .map(value =>
          zio.aws.qldb.model.JournalKinesisStreamDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse
  ): zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly =
    new Wrapper(impl)
}
