package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{Arn, Timestamp, LedgerName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExportJournalToS3Request(
    name: LedgerName,
    inclusiveStartTime: Timestamp,
    exclusiveEndTime: Timestamp,
    s3ExportConfiguration: zio.aws.qldb.model.S3ExportConfiguration,
    roleArn: Arn,
    outputFormat: Option[zio.aws.qldb.model.OutputFormat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request = {
    import ExportJournalToS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .inclusiveStartTime(Timestamp.unwrap(inclusiveStartTime): Instant)
      .exclusiveEndTime(Timestamp.unwrap(exclusiveEndTime): Instant)
      .s3ExportConfiguration(s3ExportConfiguration.buildAwsValue())
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ExportJournalToS3Request.ReadOnly =
    zio.aws.qldb.model.ExportJournalToS3Request.wrap(buildAwsValue())
}
object ExportJournalToS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ExportJournalToS3Request =
      zio.aws.qldb.model.ExportJournalToS3Request(
        name,
        inclusiveStartTime,
        exclusiveEndTime,
        s3ExportConfiguration.asEditable,
        roleArn,
        outputFormat.map(value => value)
      )
    def name: LedgerName
    def inclusiveStartTime: Timestamp
    def exclusiveEndTime: Timestamp
    def s3ExportConfiguration: zio.aws.qldb.model.S3ExportConfiguration.ReadOnly
    def roleArn: Arn
    def outputFormat: Option[zio.aws.qldb.model.OutputFormat]
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getInclusiveStartTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(inclusiveStartTime)
    def getExclusiveEndTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(exclusiveEndTime)
    def getS3ExportConfiguration
        : ZIO[Any, Nothing, zio.aws.qldb.model.S3ExportConfiguration.ReadOnly] =
      ZIO.succeed(s3ExportConfiguration)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getOutputFormat: ZIO[Any, AwsError, zio.aws.qldb.model.OutputFormat] =
      AwsError.unwrapOptionField("outputFormat", outputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request
  ) extends zio.aws.qldb.model.ExportJournalToS3Request.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val inclusiveStartTime: Timestamp =
      zio.aws.qldb.model.primitives.Timestamp(impl.inclusiveStartTime())
    override val exclusiveEndTime: Timestamp =
      zio.aws.qldb.model.primitives.Timestamp(impl.exclusiveEndTime())
    override val s3ExportConfiguration
        : zio.aws.qldb.model.S3ExportConfiguration.ReadOnly =
      zio.aws.qldb.model.S3ExportConfiguration
        .wrap(impl.s3ExportConfiguration())
    override val roleArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.roleArn())
    override val outputFormat: Option[zio.aws.qldb.model.OutputFormat] = scala
      .Option(impl.outputFormat())
      .map(value => zio.aws.qldb.model.OutputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request
  ): zio.aws.qldb.model.ExportJournalToS3Request.ReadOnly = new Wrapper(impl)
}
