package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KinesisConfiguration(
    streamArn: Arn,
    aggregationEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.KinesisConfiguration = {
    import KinesisConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.KinesisConfiguration
      .builder()
      .streamArn(Arn.unwrap(streamArn): java.lang.String)
      .optionallyWith(
        aggregationEnabled.map(value => value: java.lang.Boolean)
      )(_.aggregationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.KinesisConfiguration.ReadOnly =
    zio.aws.qldb.model.KinesisConfiguration.wrap(buildAwsValue())
}
object KinesisConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.KinesisConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.KinesisConfiguration = zio.aws.qldb.model
      .KinesisConfiguration(streamArn, aggregationEnabled.map(value => value))
    def streamArn: Arn
    def aggregationEnabled: Option[Boolean]
    def getStreamArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(streamArn)
    def getAggregationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("aggregationEnabled", aggregationEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.KinesisConfiguration
  ) extends zio.aws.qldb.model.KinesisConfiguration.ReadOnly {
    override val streamArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.streamArn())
    override val aggregationEnabled: Option[Boolean] =
      scala.Option(impl.aggregationEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.KinesisConfiguration
  ): zio.aws.qldb.model.KinesisConfiguration.ReadOnly = new Wrapper(impl)
}
