package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.qldb.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ListTagsForResourceRequest =
      zio.aws.qldb.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest
  ) extends zio.aws.qldb.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest
  ): zio.aws.qldb.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
