package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{UniqueId, LedgerName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeJournalS3ExportRequest(
    name: LedgerName,
    exportId: UniqueId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest = {
    import DescribeJournalS3ExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .exportId(UniqueId.unwrap(exportId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.DescribeJournalS3ExportRequest.ReadOnly =
    zio.aws.qldb.model.DescribeJournalS3ExportRequest.wrap(buildAwsValue())
}
object DescribeJournalS3ExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.DescribeJournalS3ExportRequest =
      zio.aws.qldb.model.DescribeJournalS3ExportRequest(name, exportId)
    def name: LedgerName
    def exportId: UniqueId
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getExportId: ZIO[Any, Nothing, UniqueId] = ZIO.succeed(exportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest
  ) extends zio.aws.qldb.model.DescribeJournalS3ExportRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val exportId: UniqueId =
      zio.aws.qldb.model.primitives.UniqueId(impl.exportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest
  ): zio.aws.qldb.model.DescribeJournalS3ExportRequest.ReadOnly = new Wrapper(
    impl
  )
}
