package zio.aws.qldb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBlockResponse(
    block: zio.aws.qldb.model.ValueHolder,
    proof: Option[zio.aws.qldb.model.ValueHolder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.GetBlockResponse = {
    import GetBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.GetBlockResponse
      .builder()
      .block(block.buildAwsValue())
      .optionallyWith(proof.map(value => value.buildAwsValue()))(_.proof)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.GetBlockResponse.ReadOnly =
    zio.aws.qldb.model.GetBlockResponse.wrap(buildAwsValue())
}
object GetBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.GetBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.GetBlockResponse = zio.aws.qldb.model
      .GetBlockResponse(block.asEditable, proof.map(value => value.asEditable))
    def block: zio.aws.qldb.model.ValueHolder.ReadOnly
    def proof: Option[zio.aws.qldb.model.ValueHolder.ReadOnly]
    def getBlock: ZIO[Any, Nothing, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      ZIO.succeed(block)
    def getProof: ZIO[Any, AwsError, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      AwsError.unwrapOptionField("proof", proof)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.GetBlockResponse
  ) extends zio.aws.qldb.model.GetBlockResponse.ReadOnly {
    override val block: zio.aws.qldb.model.ValueHolder.ReadOnly =
      zio.aws.qldb.model.ValueHolder.wrap(impl.block())
    override val proof: Option[zio.aws.qldb.model.ValueHolder.ReadOnly] = scala
      .Option(impl.proof())
      .map(value => zio.aws.qldb.model.ValueHolder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.GetBlockResponse
  ): zio.aws.qldb.model.GetBlockResponse.ReadOnly = new Wrapper(impl)
}
