package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListJournalKinesisStreamsForLedgerResponse(
    streams: Option[
      Iterable[zio.aws.qldb.model.JournalKinesisStreamDescription]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse = {
    import ListJournalKinesisStreamsForLedgerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
      .builder()
      .optionallyWith(
        streams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streams)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly =
    zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse
      .wrap(buildAwsValue())
}
object ListJournalKinesisStreamsForLedgerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse =
      zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse(
        streams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def streams: Option[
      List[zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getStreams: ZIO[Any, AwsError, List[
      zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("streams", streams)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
  ) extends zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly {
    override val streams: Option[
      List[zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly]
    ] = scala
      .Option(impl.streams())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.qldb.model.JournalKinesisStreamDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
  ): zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly =
    new Wrapper(impl)
}
