package zio.aws.qldb.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionStatus {
  def unwrap: software.amazon.awssdk.services.qldb.model.EncryptionStatus
}
object EncryptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.EncryptionStatus
  ): zio.aws.qldb.model.EncryptionStatus = value match {
    case software.amazon.awssdk.services.qldb.model.EncryptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.EncryptionStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.qldb.model.EncryptionStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.qldb.model.EncryptionStatus.KMS_KEY_INACCESSIBLE =>
      val r = KMS_KEY_INACCESSIBLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.EncryptionStatus =
      software.amazon.awssdk.services.qldb.model.EncryptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.qldb.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.EncryptionStatus =
      software.amazon.awssdk.services.qldb.model.EncryptionStatus.ENABLED
  }
  case object UPDATING extends zio.aws.qldb.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.EncryptionStatus =
      software.amazon.awssdk.services.qldb.model.EncryptionStatus.UPDATING
  }
  case object KMS_KEY_INACCESSIBLE extends zio.aws.qldb.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.EncryptionStatus =
      software.amazon.awssdk.services.qldb.model.EncryptionStatus.KMS_KEY_INACCESSIBLE
  }
}
