package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServiceSyncConfigResponse(
    serviceSyncConfig: Optional[zio.aws.proton.model.ServiceSyncConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigResponse = {
    import UpdateServiceSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigResponse
      .builder()
      .optionallyWith(serviceSyncConfig.map(value => value.buildAwsValue()))(
        _.serviceSyncConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateServiceSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.UpdateServiceSyncConfigResponse.wrap(buildAwsValue())
}
object UpdateServiceSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceSyncConfigResponse =
      zio.aws.proton.model.UpdateServiceSyncConfigResponse(
        serviceSyncConfig.map(value => value.asEditable)
      )
    def serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly]
    def getServiceSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("serviceSyncConfig", serviceSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigResponse
  ) extends zio.aws.proton.model.UpdateServiceSyncConfigResponse.ReadOnly {
    override val serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSyncConfig())
        .map(value => zio.aws.proton.model.ServiceSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigResponse
  ): zio.aws.proton.model.UpdateServiceSyncConfigResponse.ReadOnly =
    new Wrapper(impl)
}
