package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.proton.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.SortOrder
  ): zio.aws.proton.model.SortOrder = value match {
    case software.amazon.awssdk.services.proton.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.proton.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.proton.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.SortOrder =
      software.amazon.awssdk.services.proton.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.proton.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.SortOrder =
      software.amazon.awssdk.services.proton.model.SortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.proton.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.SortOrder =
      software.amazon.awssdk.services.proton.model.SortOrder.DESCENDING
  }
}
