package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceSyncBlockerSummary(
    latestBlockers: Optional[Iterable[zio.aws.proton.model.SyncBlocker]] =
      Optional.Absent,
    serviceInstanceName: Optional[String] = Optional.Absent,
    serviceName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceSyncBlockerSummary = {
    import ServiceSyncBlockerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceSyncBlockerSummary
      .builder()
      .optionallyWith(
        latestBlockers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.latestBlockers)
      .optionallyWith(
        serviceInstanceName.map(value => value: java.lang.String)
      )(_.serviceInstanceName)
      .serviceName(serviceName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceSyncBlockerSummary.ReadOnly =
    zio.aws.proton.model.ServiceSyncBlockerSummary.wrap(buildAwsValue())
}
object ServiceSyncBlockerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceSyncBlockerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceSyncBlockerSummary =
      zio.aws.proton.model.ServiceSyncBlockerSummary(
        latestBlockers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceInstanceName.map(value => value),
        serviceName
      )
    def latestBlockers
        : Optional[List[zio.aws.proton.model.SyncBlocker.ReadOnly]]
    def serviceInstanceName: Optional[String]
    def serviceName: String
    def getLatestBlockers
        : ZIO[Any, AwsError, List[zio.aws.proton.model.SyncBlocker.ReadOnly]] =
      AwsError.unwrapOptionField("latestBlockers", latestBlockers)
    def getServiceInstanceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, Nothing, String] = ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceSyncBlockerSummary
  ) extends zio.aws.proton.model.ServiceSyncBlockerSummary.ReadOnly {
    override val latestBlockers
        : Optional[List[zio.aws.proton.model.SyncBlocker.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestBlockers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.SyncBlocker.wrap(item)
          }.toList
        )
    override val serviceInstanceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceInstanceName())
      .map(value => value: String)
    override val serviceName: String = impl.serviceName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceSyncBlockerSummary
  ): zio.aws.proton.model.ServiceSyncBlockerSummary.ReadOnly = new Wrapper(impl)
}
