package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Timestamp,
  Arn,
  DeploymentId,
  SpecContents,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class ServicePipeline(
    arn: Arn,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    lastAttemptedDeploymentId: Optional[DeploymentId] = Optional.Absent,
    lastDeploymentAttemptedAt: Timestamp,
    lastDeploymentSucceededAt: Timestamp,
    lastSucceededDeploymentId: Optional[DeploymentId] = Optional.Absent,
    spec: Optional[SpecContents] = Optional.Absent,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServicePipeline = {
    import ServicePipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServicePipeline
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .optionallyWith(
        lastAttemptedDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastAttemptedDeploymentId)
      .lastDeploymentAttemptedAt(
        Timestamp.unwrap(lastDeploymentAttemptedAt): Instant
      )
      .lastDeploymentSucceededAt(
        Timestamp.unwrap(lastDeploymentSucceededAt): Instant
      )
      .optionallyWith(
        lastSucceededDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastSucceededDeploymentId)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServicePipeline.ReadOnly =
    zio.aws.proton.model.ServicePipeline.wrap(buildAwsValue())
}
object ServicePipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServicePipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServicePipeline =
      zio.aws.proton.model.ServicePipeline(
        arn,
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        lastAttemptedDeploymentId.map(value => value),
        lastDeploymentAttemptedAt,
        lastDeploymentSucceededAt,
        lastSucceededDeploymentId.map(value => value),
        spec.map(value => value),
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def arn: Arn
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def lastAttemptedDeploymentId: Optional[DeploymentId]
    def lastDeploymentAttemptedAt: Timestamp
    def lastDeploymentSucceededAt: Timestamp
    def lastSucceededDeploymentId: Optional[DeploymentId]
    def spec: Optional[SpecContents]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getLastAttemptedDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastAttemptedDeploymentId",
        lastAttemptedDeploymentId
      )
    def getLastDeploymentAttemptedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentSucceededAt)
    def getLastSucceededDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastSucceededDeploymentId",
        lastSucceededDeploymentId
      )
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServicePipeline
  ) extends zio.aws.proton.model.ServicePipeline.ReadOnly {
    override val arn: Arn = zio.aws.proton.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val lastAttemptedDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptedDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val lastDeploymentAttemptedAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentAttemptedAt())
    override val lastDeploymentSucceededAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentSucceededAt())
    override val lastSucceededDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSucceededDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val spec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServicePipeline
  ): zio.aws.proton.model.ServicePipeline.ReadOnly = new Wrapper(impl)
}
