package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Timestamp,
  DeploymentId,
  ServiceInstanceArn,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class ServiceInstanceSummary(
    arn: ServiceInstanceArn,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    environmentName: ResourceName,
    lastAttemptedDeploymentId: Optional[DeploymentId] = Optional.Absent,
    lastDeploymentAttemptedAt: Timestamp,
    lastDeploymentSucceededAt: Timestamp,
    lastSucceededDeploymentId: Optional[DeploymentId] = Optional.Absent,
    name: ResourceName,
    serviceName: ResourceName,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceInstanceSummary = {
    import ServiceInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceInstanceSummary
      .builder()
      .arn(ServiceInstanceArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .optionallyWith(
        lastAttemptedDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastAttemptedDeploymentId)
      .lastDeploymentAttemptedAt(
        Timestamp.unwrap(lastDeploymentAttemptedAt): Instant
      )
      .lastDeploymentSucceededAt(
        Timestamp.unwrap(lastDeploymentSucceededAt): Instant
      )
      .optionallyWith(
        lastSucceededDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastSucceededDeploymentId)
      .name(ResourceName.unwrap(name): java.lang.String)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceInstanceSummary.ReadOnly =
    zio.aws.proton.model.ServiceInstanceSummary.wrap(buildAwsValue())
}
object ServiceInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceInstanceSummary =
      zio.aws.proton.model.ServiceInstanceSummary(
        arn,
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        environmentName,
        lastAttemptedDeploymentId.map(value => value),
        lastDeploymentAttemptedAt,
        lastDeploymentSucceededAt,
        lastSucceededDeploymentId.map(value => value),
        name,
        serviceName,
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def arn: ServiceInstanceArn
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def environmentName: ResourceName
    def lastAttemptedDeploymentId: Optional[DeploymentId]
    def lastDeploymentAttemptedAt: Timestamp
    def lastDeploymentSucceededAt: Timestamp
    def lastSucceededDeploymentId: Optional[DeploymentId]
    def name: ResourceName
    def serviceName: ResourceName
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, ServiceInstanceArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getLastAttemptedDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastAttemptedDeploymentId",
        lastAttemptedDeploymentId
      )
    def getLastDeploymentAttemptedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentSucceededAt)
    def getLastSucceededDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastSucceededDeploymentId",
        lastSucceededDeploymentId
      )
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceInstanceSummary
  ) extends zio.aws.proton.model.ServiceInstanceSummary.ReadOnly {
    override val arn: ServiceInstanceArn =
      zio.aws.proton.model.primitives.ServiceInstanceArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val lastAttemptedDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptedDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val lastDeploymentAttemptedAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentAttemptedAt())
    override val lastDeploymentSucceededAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentSucceededAt())
    override val lastSucceededDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSucceededDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceInstanceSummary
  ): zio.aws.proton.model.ServiceInstanceSummary.ReadOnly = new Wrapper(impl)
}
