package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  TemplateVersionPart,
  SpecContents,
  DeploymentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceInstanceState(
    lastSuccessfulComponentDeploymentIds: Optional[Iterable[DeploymentId]] =
      Optional.Absent,
    lastSuccessfulEnvironmentDeploymentId: Optional[DeploymentId] =
      Optional.Absent,
    lastSuccessfulServicePipelineDeploymentId: Optional[DeploymentId] =
      Optional.Absent,
    spec: SpecContents,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceInstanceState = {
    import ServiceInstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceInstanceState
      .builder()
      .optionallyWith(
        lastSuccessfulComponentDeploymentIds.map(value =>
          value.map { item =>
            DeploymentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lastSuccessfulComponentDeploymentIds)
      .optionallyWith(
        lastSuccessfulEnvironmentDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulEnvironmentDeploymentId)
      .optionallyWith(
        lastSuccessfulServicePipelineDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulServicePipelineDeploymentId)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceInstanceState.ReadOnly =
    zio.aws.proton.model.ServiceInstanceState.wrap(buildAwsValue())
}
object ServiceInstanceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceInstanceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceInstanceState =
      zio.aws.proton.model.ServiceInstanceState(
        lastSuccessfulComponentDeploymentIds.map(value => value),
        lastSuccessfulEnvironmentDeploymentId.map(value => value),
        lastSuccessfulServicePipelineDeploymentId.map(value => value),
        spec,
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def lastSuccessfulComponentDeploymentIds: Optional[List[DeploymentId]]
    def lastSuccessfulEnvironmentDeploymentId: Optional[DeploymentId]
    def lastSuccessfulServicePipelineDeploymentId: Optional[DeploymentId]
    def spec: SpecContents
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getLastSuccessfulComponentDeploymentIds
        : ZIO[Any, AwsError, List[DeploymentId]] = AwsError.unwrapOptionField(
      "lastSuccessfulComponentDeploymentIds",
      lastSuccessfulComponentDeploymentIds
    )
    def getLastSuccessfulEnvironmentDeploymentId
        : ZIO[Any, AwsError, DeploymentId] = AwsError.unwrapOptionField(
      "lastSuccessfulEnvironmentDeploymentId",
      lastSuccessfulEnvironmentDeploymentId
    )
    def getLastSuccessfulServicePipelineDeploymentId
        : ZIO[Any, AwsError, DeploymentId] = AwsError.unwrapOptionField(
      "lastSuccessfulServicePipelineDeploymentId",
      lastSuccessfulServicePipelineDeploymentId
    )
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceInstanceState
  ) extends zio.aws.proton.model.ServiceInstanceState.ReadOnly {
    override val lastSuccessfulComponentDeploymentIds
        : Optional[List[DeploymentId]] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSuccessfulComponentDeploymentIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.primitives.DeploymentId(item)
        }.toList
      )
    override val lastSuccessfulEnvironmentDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulEnvironmentDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val lastSuccessfulServicePipelineDeploymentId
        : Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSuccessfulServicePipelineDeploymentId())
      .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceInstanceState
  ): zio.aws.proton.model.ServiceInstanceState.ReadOnly = new Wrapper(impl)
}
