package zio.aws.proton.model
import zio.aws.proton.model.primitives.{RepositoryName, Arn, RepositoryArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RepositorySummary(
    arn: RepositoryArn,
    connectionArn: Arn,
    name: RepositoryName,
    provider: zio.aws.proton.model.RepositoryProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RepositorySummary = {
    import RepositorySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RepositorySummary
      .builder()
      .arn(RepositoryArn.unwrap(arn): java.lang.String)
      .connectionArn(Arn.unwrap(connectionArn): java.lang.String)
      .name(RepositoryName.unwrap(name): java.lang.String)
      .provider(provider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.RepositorySummary.ReadOnly =
    zio.aws.proton.model.RepositorySummary.wrap(buildAwsValue())
}
object RepositorySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RepositorySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.RepositorySummary =
      zio.aws.proton.model.RepositorySummary(arn, connectionArn, name, provider)
    def arn: RepositoryArn
    def connectionArn: Arn
    def name: RepositoryName
    def provider: zio.aws.proton.model.RepositoryProvider
    def getArn: ZIO[Any, Nothing, RepositoryArn] = ZIO.succeed(arn)
    def getConnectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(connectionArn)
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RepositorySummary
  ) extends zio.aws.proton.model.RepositorySummary.ReadOnly {
    override val arn: RepositoryArn =
      zio.aws.proton.model.primitives.RepositoryArn(impl.arn())
    override val connectionArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.connectionArn())
    override val name: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.name())
    override val provider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.provider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RepositorySummary
  ): zio.aws.proton.model.RepositorySummary.ReadOnly = new Wrapper(impl)
}
