package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDeploymentsResponse(
    deployments: Iterable[zio.aws.proton.model.DeploymentSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListDeploymentsResponse = {
    import ListDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListDeploymentsResponse
      .builder()
      .deployments(deployments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListDeploymentsResponse.ReadOnly =
    zio.aws.proton.model.ListDeploymentsResponse.wrap(buildAwsValue())
}
object ListDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListDeploymentsResponse =
      zio.aws.proton.model.ListDeploymentsResponse(
        deployments.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def deployments: List[zio.aws.proton.model.DeploymentSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDeployments: ZIO[Any, Nothing, List[
      zio.aws.proton.model.DeploymentSummary.ReadOnly
    ]] = ZIO.succeed(deployments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListDeploymentsResponse
  ) extends zio.aws.proton.model.ListDeploymentsResponse.ReadOnly {
    override val deployments
        : List[zio.aws.proton.model.DeploymentSummary.ReadOnly] = impl
      .deployments()
      .asScala
      .map { item =>
        zio.aws.proton.model.DeploymentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListDeploymentsResponse
  ): zio.aws.proton.model.ListDeploymentsResponse.ReadOnly = new Wrapper(impl)
}
