package zio.aws.proton.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.proton.model.primitives.{NextToken, MaxPageResults, ResourceName}
import scala.jdk.CollectionConverters._
final case class ListDeploymentsRequest(
    componentName: Optional[ResourceName] = Optional.Absent,
    environmentName: Optional[ResourceName] = Optional.Absent,
    maxResults: Optional[MaxPageResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListDeploymentsRequest = {
    import ListDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListDeploymentsRequest
      .builder()
      .optionallyWith(
        componentName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        environmentName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListDeploymentsRequest.ReadOnly =
    zio.aws.proton.model.ListDeploymentsRequest.wrap(buildAwsValue())
}
object ListDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListDeploymentsRequest =
      zio.aws.proton.model.ListDeploymentsRequest(
        componentName.map(value => value),
        environmentName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceInstanceName.map(value => value),
        serviceName.map(value => value)
      )
    def componentName: Optional[ResourceName]
    def environmentName: Optional[ResourceName]
    def maxResults: Optional[MaxPageResults]
    def nextToken: Optional[NextToken]
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: Optional[ResourceName]
    def getComponentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getEnvironmentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListDeploymentsRequest
  ) extends zio.aws.proton.model.ListDeploymentsRequest.ReadOnly {
    override val componentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val environmentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val maxResults: Optional[MaxPageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListDeploymentsRequest
  ): zio.aws.proton.model.ListDeploymentsRequest.ReadOnly = new Wrapper(impl)
}
