package zio.aws.proton.model
import zio.aws.proton.model.primitives.EmptyNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListComponentOutputsResponse(
    nextToken: Optional[EmptyNextToken] = Optional.Absent,
    outputs: Iterable[zio.aws.proton.model.Output]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse = {
    import ListComponentOutputsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListComponentOutputsResponse.ReadOnly =
    zio.aws.proton.model.ListComponentOutputsResponse.wrap(buildAwsValue())
}
object ListComponentOutputsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListComponentOutputsResponse =
      zio.aws.proton.model.ListComponentOutputsResponse(
        nextToken.map(value => value),
        outputs.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[EmptyNextToken]
    def outputs: List[zio.aws.proton.model.Output.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOutputs
        : ZIO[Any, Nothing, List[zio.aws.proton.model.Output.ReadOnly]] =
      ZIO.succeed(outputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse
  ) extends zio.aws.proton.model.ListComponentOutputsResponse.ReadOnly {
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val outputs: List[zio.aws.proton.model.Output.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.proton.model.Output.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse
  ): zio.aws.proton.model.ListComponentOutputsResponse.ReadOnly = new Wrapper(
    impl
  )
}
