package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEnvironmentTemplateRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest = {
    import GetEnvironmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetEnvironmentTemplateRequest.ReadOnly =
    zio.aws.proton.model.GetEnvironmentTemplateRequest.wrap(buildAwsValue())
}
object GetEnvironmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetEnvironmentTemplateRequest =
      zio.aws.proton.model.GetEnvironmentTemplateRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest
  ) extends zio.aws.proton.model.GetEnvironmentTemplateRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest
  ): zio.aws.proton.model.GetEnvironmentTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
