package zio.aws.proton.model
import zio.aws.proton.model.primitives.{DeploymentId, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeploymentRequest(
    componentName: Optional[ResourceName] = Optional.Absent,
    environmentName: Optional[ResourceName] = Optional.Absent,
    id: DeploymentId,
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetDeploymentRequest = {
    import GetDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetDeploymentRequest
      .builder()
      .optionallyWith(
        componentName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        environmentName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .id(DeploymentId.unwrap(id): java.lang.String)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetDeploymentRequest.ReadOnly =
    zio.aws.proton.model.GetDeploymentRequest.wrap(buildAwsValue())
}
object GetDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetDeploymentRequest =
      zio.aws.proton.model.GetDeploymentRequest(
        componentName.map(value => value),
        environmentName.map(value => value),
        id,
        serviceInstanceName.map(value => value),
        serviceName.map(value => value)
      )
    def componentName: Optional[ResourceName]
    def environmentName: Optional[ResourceName]
    def id: DeploymentId
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: Optional[ResourceName]
    def getComponentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getEnvironmentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getId: ZIO[Any, Nothing, DeploymentId] = ZIO.succeed(id)
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetDeploymentRequest
  ) extends zio.aws.proton.model.GetDeploymentRequest.ReadOnly {
    override val componentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val environmentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val id: DeploymentId =
      zio.aws.proton.model.primitives.DeploymentId(impl.id())
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetDeploymentRequest
  ): zio.aws.proton.model.GetDeploymentRequest.ReadOnly = new Wrapper(impl)
}
