package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  TemplateVersionPart,
  EnvironmentArn,
  Timestamp,
  Arn,
  DeploymentId,
  Description,
  AwsAccountId,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class EnvironmentSummary(
    arn: EnvironmentArn,
    componentRoleArn: Optional[Arn] = Optional.Absent,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId] =
      Optional.Absent,
    environmentAccountId: Optional[AwsAccountId] = Optional.Absent,
    lastAttemptedDeploymentId: Optional[DeploymentId] = Optional.Absent,
    lastDeploymentAttemptedAt: Timestamp,
    lastDeploymentSucceededAt: Timestamp,
    lastSucceededDeploymentId: Optional[DeploymentId] = Optional.Absent,
    name: ResourceName,
    protonServiceRoleArn: Optional[Arn] = Optional.Absent,
    provisioning: Optional[zio.aws.proton.model.Provisioning] = Optional.Absent,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.EnvironmentSummary = {
    import EnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.EnvironmentSummary
      .builder()
      .arn(EnvironmentArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        componentRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .optionallyWith(
        environmentAccountId.map(value =>
          AwsAccountId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountId)
      .optionallyWith(
        lastAttemptedDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastAttemptedDeploymentId)
      .lastDeploymentAttemptedAt(
        Timestamp.unwrap(lastDeploymentAttemptedAt): Instant
      )
      .lastDeploymentSucceededAt(
        Timestamp.unwrap(lastDeploymentSucceededAt): Instant
      )
      .optionallyWith(
        lastSucceededDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastSucceededDeploymentId)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(provisioning.map(value => value.unwrap))(_.provisioning)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.EnvironmentSummary.ReadOnly =
    zio.aws.proton.model.EnvironmentSummary.wrap(buildAwsValue())
}
object EnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.EnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.EnvironmentSummary =
      zio.aws.proton.model.EnvironmentSummary(
        arn,
        componentRoleArn.map(value => value),
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        environmentAccountId.map(value => value),
        lastAttemptedDeploymentId.map(value => value),
        lastDeploymentAttemptedAt,
        lastDeploymentSucceededAt,
        lastSucceededDeploymentId.map(value => value),
        name,
        protonServiceRoleArn.map(value => value),
        provisioning.map(value => value),
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def arn: EnvironmentArn
    def componentRoleArn: Optional[Arn]
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def description: Optional[Description]
    def environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId]
    def environmentAccountId: Optional[AwsAccountId]
    def lastAttemptedDeploymentId: Optional[DeploymentId]
    def lastDeploymentAttemptedAt: Timestamp
    def lastDeploymentSucceededAt: Timestamp
    def lastSucceededDeploymentId: Optional[DeploymentId]
    def name: ResourceName
    def protonServiceRoleArn: Optional[Arn]
    def provisioning: Optional[zio.aws.proton.model.Provisioning]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, EnvironmentArn] = ZIO.succeed(arn)
    def getComponentRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getEnvironmentAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("environmentAccountId", environmentAccountId)
    def getLastAttemptedDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastAttemptedDeploymentId",
        lastAttemptedDeploymentId
      )
    def getLastDeploymentAttemptedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentSucceededAt)
    def getLastSucceededDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastSucceededDeploymentId",
        lastSucceededDeploymentId
      )
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioning: ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("provisioning", provisioning)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentSummary
  ) extends zio.aws.proton.model.EnvironmentSummary.ReadOnly {
    override val arn: EnvironmentArn =
      zio.aws.proton.model.primitives.EnvironmentArn(impl.arn())
    override val componentRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Optional[EnvironmentAccountConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val environmentAccountId: Optional[AwsAccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentAccountId())
        .map(value => zio.aws.proton.model.primitives.AwsAccountId(value))
    override val lastAttemptedDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptedDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val lastDeploymentAttemptedAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentAttemptedAt())
    override val lastDeploymentSucceededAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentSucceededAt())
    override val lastSucceededDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSucceededDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioning: Optional[zio.aws.proton.model.Provisioning] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioning())
        .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentSummary
  ): zio.aws.proton.model.EnvironmentSummary.ReadOnly = new Wrapper(impl)
}
